/*
 * Decompiled with CFR 0.152.
 */
package com.work4games.entity;

import com.work4games.entity.Object;
import com.work4games.handlers.Content;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;

public class Gem
extends Object {
    private BufferedImage sprite;
    private int gemType;
    private boolean wait = false;
    private boolean selected = false;
    private boolean swap = false;
    private int tempx;
    private int tempy;
    private double dx = 4.0;
    private double dy = 4.0;
    private double bx;
    private double by;
    private int row;
    private int col;
    private boolean hint = false;
    public static final int NUMOFGEMS = 6;
    public static final int SAPPHIRE = 0;
    public static final int RUBY = 1;
    public static final int EMERALD = 2;
    public static final int DIAMOND = 3;
    public static final int AMBER = 4;
    public static final int AMETHYST = 5;

    public Gem(int x, int y, int row, int col) {
        this.ID = 0;
        this.row = row;
        this.col = col;
        int randomInt = (int)(Math.random() * 6.0 + 1.0);
        switch (randomInt) {
            case 1: {
                this.sprite = Content.Sapphire;
                this.gemType = 0;
                break;
            }
            case 2: {
                this.sprite = Content.Ruby;
                this.gemType = 1;
                break;
            }
            case 3: {
                this.sprite = Content.Emerald;
                this.gemType = 2;
                break;
            }
            case 4: {
                this.sprite = Content.Diamond;
                this.gemType = 3;
                break;
            }
            case 5: {
                this.sprite = Content.Amber;
                this.gemType = 4;
                break;
            }
            case 6: {
                this.sprite = Content.Amethyst;
                this.gemType = 5;
            }
        }
        this.cwidth = 32;
        this.width = 32;
        this.cheight = 32;
        this.height = 32;
        this.x = x;
        this.y = y;
        this.bx = x;
        this.by = y;
    }

    public void update() {
        if (this.swap) {
            int diry;
            this.swap = false;
            int dirx = this.tempx - (int)this.bx;
            if (dirx != 0) {
                this.swap = true;
                this.bx = dirx > 0 ? (this.bx += this.dx) : (this.bx -= this.dx);
                if (((double)this.tempx - this.bx) % 40.0 == 0.0) {
                    this.wait = false;
                }
            }
            if ((diry = this.tempy - (int)this.by) != 0) {
                this.swap = true;
                this.by = diry > 0 ? (this.by += this.dy) : (this.by -= this.dy);
                if (((double)this.tempy - this.by) % 40.0 == 0.0) {
                    this.wait = false;
                }
            }
        }
    }

    @Override
    public void draw(Graphics2D g) {
        this.x = (int)this.bx;
        this.y = (int)this.by;
        g.drawImage((Image)this.sprite, this.x, this.y, null);
        if (this.selected) {
            g.setColor(Color.YELLOW);
            g.drawRect(this.x - 2, this.y - 2, this.width + 4, this.height + 4);
        } else if (this.hint) {
            g.setColor(Color.RED);
            g.drawRect(this.x - 2, this.y - 2, this.width + 4, this.height + 4);
            g.drawRect(this.x - 1, this.y - 1, this.width + 2, this.height + 2);
        }
    }

    public void swap(Gem g) {
        this.swap = true;
        g.setSwap(true);
        int temprow = this.row;
        int tempcol = this.col;
        this.tempx = g.getx();
        this.tempy = g.gety();
        this.row = g.getRow();
        this.col = g.getCol();
        g.setTempPosition(this.x, this.y);
        g.setRow(temprow);
        g.setCol(tempcol);
    }

    public void swap(int tempx, int tempy, int row, int col) {
        this.swap = true;
        this.wait = true;
        this.tempx = tempx;
        this.tempy = tempy;
        this.row = row;
        this.col = col;
    }

    public int getGemType() {
        return this.gemType;
    }

    public boolean getWait() {
        return this.wait;
    }

    public void setGemType(int type) {
        switch (type) {
            case 0: {
                this.sprite = Content.Sapphire;
                this.gemType = 0;
                break;
            }
            case 1: {
                this.sprite = Content.Ruby;
                this.gemType = 1;
                break;
            }
            case 2: {
                this.sprite = Content.Emerald;
                this.gemType = 2;
                break;
            }
            case 3: {
                this.sprite = Content.Diamond;
                this.gemType = 3;
                break;
            }
            case 4: {
                this.sprite = Content.Amber;
                this.gemType = 4;
                break;
            }
            case 5: {
                this.sprite = Content.Amethyst;
                this.gemType = 5;
            }
        }
    }

    public void addX(double x) {
        this.bx += x;
    }

    public void addY(double y) {
        this.by += y;
    }

    public boolean getSelected() {
        return this.selected;
    }

    public void setSelected(boolean b) {
        this.selected = b;
    }

    public int getRow() {
        return this.row;
    }

    public void setRow(int r) {
        this.row = r;
    }

    public int getCol() {
        return this.col;
    }

    public void setCol(int c) {
        this.col = c;
    }

    public boolean getSwap() {
        return this.swap;
    }

    public void setSwap(boolean b) {
        this.swap = b;
    }

    public void setHint(boolean b) {
        this.hint = b;
    }

    public void setTempPosition(int x, int y) {
        this.tempx = x;
        this.tempy = y;
    }
}

